import {FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import Flex from 'components/Flex/Flex';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';
import Card from 'components/Card/Card';
import Box from 'components/Box/Box';

import cx from './WeatherForecastSkeleton.scss';

export interface IWeatherForecastSkeletonProps extends IWithClassName {}

const WeatherForecastSkeleton: FC<IWeatherForecastSkeletonProps> = ({
    className,
}) => {
    return (
        <Card className={className} shadow="default">
            <Box x={6} y={4}>
                <TextSkeleton
                    withAnimation
                    size="xl"
                    className={cx('heading')}
                />
                <Flex
                    flexDirection="row"
                    justifyContent="space-between"
                    alignItems="center"
                    y={3}
                >
                    <ButtonSkeleton withAnimation className={cx('icon')} />
                    <Flex flexDirection="column" className={cx('text')}>
                        <TextSkeleton withAnimation size="m" />
                        <TextSkeleton withAnimation size="s" />
                    </Flex>
                </Flex>
            </Box>
        </Card>
    );
};

export default WeatherForecastSkeleton;
