import React from 'react';

import {IHotelOrOfferBadge} from 'types/hotels/offer/IHotelOffer';
import {IIconProps} from 'icons/types/icon';
import {IWithClassName} from 'types/withClassName';

import {useWhiteLabelConfig} from 'utilities/hooks/useWhiteLabelConfig';

import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

import cx from './WhiteLabelLoyaltyBadge.scss';

interface IWhiteLabelLoyaltyBadgeProps extends IWithClassName {
    badge: IHotelOrOfferBadge | undefined;
}

const DEFAULT_ICON_SIZE = 15;

const DEFAULT_ICON_PROPS: IIconProps = {
    height: DEFAULT_ICON_SIZE,
};

const WhiteLabelLoyaltyBadge: React.FC<IWhiteLabelLoyaltyBadgeProps> = ({
    className,
    badge,
}) => {
    const {config: whiteLabelConfig} = useWhiteLabelConfig();
    const icon = whiteLabelConfig?.badgeLogo;

    const LoyaltyIcon = React.useCallback(
        ({height}: IIconProps) => {
            // eslint-disable-next-line react/display-name
            return <img src={icon} alt="" height={height} />;
        },
        [icon],
    );

    if (badge === undefined) {
        return null;
    }

    return icon ? (
        <TextWithIcon
            className={cx('textWithIcon', className)}
            textClassName={cx('text')}
            size="xs"
            text={badge.text}
            iconLeft={LoyaltyIcon}
            iconLeftProps={DEFAULT_ICON_PROPS}
            iconLeftClassName={cx('icon')}
        />
    ) : (
        <div className={cx('text', className)}>{badge.text}</div>
    );
};

export default WhiteLabelLoyaltyBadge;
