import React from 'react';

import {IIconProps} from 'icons/types/icon';
import {IWithClassName} from 'types/withClassName';

import {useWhiteLabelConfig} from 'utilities/hooks/useWhiteLabelConfig';

export interface IWhiteLabelBadgeIconProps extends IIconProps, IWithClassName {}

export const DEFAULT_ICON_SIZE = 15;

const WhiteLabelBadgeIcon: React.FC<IWhiteLabelBadgeIconProps> = ({
    height = DEFAULT_ICON_SIZE,
    className,
}) => {
    const {config: whiteLabelConfig} = useWhiteLabelConfig();

    if (!whiteLabelConfig) {
        return null;
    }

    const {badgeLogo} = whiteLabelConfig;

    return <img src={badgeLogo} alt="" height={height} className={className} />;
};

export const S7BadgeIcon = WhiteLabelBadgeIcon;

export default React.memo(WhiteLabelBadgeIcon);
