import {IHotelOrOfferBadge, TBadgeType} from 'types/hotels/offer/IHotelOffer';
import {EWhiteLabelBadge} from 'types/common/whiteLabel/EWhiteLabelBadge';

const whiteLabelBadgeIds = new Set<TBadgeType>([EWhiteLabelBadge.S7]);

export default function getWhiteLabelBadge(
    badges: IHotelOrOfferBadge[],
): IHotelOrOfferBadge | undefined {
    return badges.find(badge => whiteLabelBadgeIds.has(badge.id));
}
