import React from 'react';

import {EWhiteLabelBadge} from 'types/common/whiteLabel/EWhiteLabelBadge';
import {EWhiteLabelPointsType} from 'types/common/whiteLabel/EWhiteLabelPointsType';

import WhiteLabelBadgeIcon, {
    IWhiteLabelBadgeIconProps,
    S7BadgeIcon,
} from '../components/WhiteLabelBadgeIcon/WhiteLabelBadgeIcon';

export function getWhiteLabelBadgeLogoById(
    id: EWhiteLabelBadge,
): React.FC<IWhiteLabelBadgeIconProps> {
    switch (id) {
        case EWhiteLabelBadge.S7:
            return S7BadgeIcon;
        default:
            return WhiteLabelBadgeIcon;
    }
}

export function getWhiteLabelBadgeLogoByPointsType(
    type: EWhiteLabelPointsType,
): React.FC<IWhiteLabelBadgeIconProps> {
    switch (type) {
        case EWhiteLabelPointsType.S7:
            return S7BadgeIcon;
        default:
            return WhiteLabelBadgeIcon;
    }
}
