import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {useWhiteLabelConfig} from 'utilities/hooks/useWhiteLabelConfig';

import cx from './WhiteLabelPartnerLogo.scss';

interface IWhiteLabelPartnerLogo extends IWithClassName, IWithQaAttributes {}

const WhiteLabelPartnerLogo: React.FC<IWhiteLabelPartnerLogo> = ({
    className,
}) => {
    const deviceType = useDeviceType();
    const {config} = useWhiteLabelConfig();

    if (!config?.logo) {
        return null;
    }

    return (
        <img
            className={cx('logo', deviceMods('logo', deviceType), className)}
            src={config?.logo}
            alt={config?.partner}
        />
    );
};

export default React.memo(WhiteLabelPartnerLogo);
