import React, {memo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {EWhiteLabelPartner} from 'types/common/whiteLabel/EWhiteLabelPartner';

import {useWhiteLabelConfig} from 'utilities/hooks/useWhiteLabelConfig';

import cx from './WhiteLabelPartnerLoyaltyLogo.scss';

export interface IWhiteLabelPartnerLoyaltyLogoProps extends IWithClassName {
    imageClassName?: string;
}

const WhiteLabelPartnerLoyaltyLogo: React.FC<IWhiteLabelPartnerLoyaltyLogoProps> =
    ({className, imageClassName}) => {
        const {config: whiteLabelConfig} = useWhiteLabelConfig();

        if (!whiteLabelConfig) {
            return null;
        }

        const logo = whiteLabelConfig.loyaltyLogo;
        const partner = whiteLabelConfig.partner;

        if (!logo) {
            return null;
        }

        return (
            <div className={cx('root', `root_${partner}`, className)}>
                {partner === EWhiteLabelPartner.S7 && (
                    <img
                        src={logo}
                        alt="S7 Loyalty Logo"
                        className={cx('img', imageClassName)}
                    />
                )}
            </div>
        );
    };

export default memo(WhiteLabelPartnerLoyaltyLogo);
