import React, {useRef} from 'react';

import {decodeParams} from 'utilities/url/decodeParams';
import {appendQueryParams} from 'utilities/url/appendQueryParams';

import DynamicScript from 'components/DynamicScript/DynamicScript';

interface IYandexConstructorMapProps {
    um: string;
    height: number | string;
    width?: number | string;
    lang?: string;
}

const scriptAttrs = {
    charset: 'utf-8',
    async: 'true',
};

const API_PATH = 'https://api-maps.yandex.ru/services/constructor/1.0/js/';

const YandexConstructorMap: React.FC<IYandexConstructorMapProps> = props => {
    const containerRef = useRef<HTMLDivElement>(null);

    return (
        <div ref={containerRef}>
            <DynamicScript
                src={appendQueryParams(API_PATH, decodeParams(props))}
                target={containerRef}
                attrs={scriptAttrs}
            />
        </div>
    );
};

export default React.memo(YandexConstructorMap);
