import {FunctionComponent} from 'react';

import {IYandexEdaPromocodePayload} from 'server/api/OrdersAPI/types/TOrdersGetOrderHappyPageApiResponse';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {humanizeDate} from 'utilities/dateUtils/humanizePeriod';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/components-YandexEdaPromo';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import Price from 'components/Price/Price';
import EdaSquareL from 'icons/illustrations/EdaSquare/EdaSquareL';

interface IYandexEdaPromoProps {
    data: IYandexEdaPromocodePayload;
}

const YandexEdaPromo: FunctionComponent<IYandexEdaPromoProps> = ({data}) => {
    const {firstSendDate, lastSendDate, numberOfPromocodes, promocodeCost} =
        data;
    const deviceType = useDeviceType();

    return (
        <Flex
            between={deviceType.isDesktop ? 7 : 4}
            inline={deviceType.isDesktop}
            flexDirection={deviceType.isDesktop ? 'row' : 'column'}
            alignItems="center"
            nowrap
        >
            <div>
                <EdaSquareL width="54" height="54" />
            </div>
            <Text size="m">
                {numberOfPromocodes > 1
                    ? insertJSXIntoKey(i18nBlock.multiPromocodesDescription)({
                          firstSendDate: humanizeDate(firstSendDate),
                          lastSendDate: humanizeDate(lastSendDate),
                          promocodeCost: <Price {...promocodeCost} />,
                      })
                    : insertJSXIntoKey(i18nBlock.singlePromocodeDescription)({
                          sendDate: humanizeDate(firstSendDate),
                          promocodeCost: <Price {...promocodeCost} />,
                      })}
            </Text>
        </Flex>
    );
};

export default YandexEdaPromo;
