import {FunctionComponent} from 'react';

import {TMetrikaGoal} from 'utilities/metrika/types/goals/all';

import {TEntryPoint} from 'components/YandexMessenger/utilities/prepareMetadata';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Hanging from 'components/Hanging/Hanging';
import YandexMessengerLink from 'components/YandexMessenger/components/YandexMessengerLink/YandexMessengerLink';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './HangingYandexMessenger.scss';

interface IHangingYandexMessenger {
    entrypoint: TEntryPoint;
    metrikaGoal: TMetrikaGoal;
}

const HangingYandexMessenger: FunctionComponent<IHangingYandexMessenger> = ({
    entrypoint,
    metrikaGoal,
}) => {
    const {isWeb} = usePlatform();
    const {isDesktop} = useDeviceType();

    if (!isWeb || isDesktop) {
        return null;
    }

    return (
        <Hanging>
            <YandexMessengerLink
                className={cx('messenger')}
                entrypoint={entrypoint}
                metrikaGoal={metrikaGoal}
            />
        </Hanging>
    );
};

export default HangingYandexMessenger;
