import {FC, ReactNode, memo, useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';

import Button, {IButtonProps} from 'components/Button/Button';
import MessageOutlineIcon from 'icons/16/MessageOutline';
import SupportChatIcon from 'icons/20/SupportChat';
import YandexMessenger, {
    IYandexMessengerCommonProps,
} from 'components/YandexMessenger/YandexMessenger';

interface IYandexMessengerButtonProps
    extends IYandexMessengerCommonProps,
        IWithClassName {
    buttonProps?: IButtonProps;
    size?: 'm' | 'l';
}

const YandexMessengerButton: FC<IYandexMessengerButtonProps> = props => {
    const {
        className,
        buttonProps: {onClick, ...buttonProps} = {},
        size = 'm',
        ...messengerProps
    } = props;

    const renderTrigger = useCallback(
        ({ref, handleClick}): ReactNode => {
            return (
                <Button
                    className={className}
                    innerRef={ref}
                    icon={
                        size === 'm' ? (
                            <MessageOutlineIcon />
                        ) : (
                            <SupportChatIcon />
                        )
                    }
                    onClick={(e): void => {
                        handleClick();
                        onClick?.(e);
                    }}
                    {...buttonProps}
                />
            );
        },
        [className, onClick, buttonProps],
    );

    return (
        <YandexMessenger renderTrigger={renderTrigger} {...messengerProps} />
    );
};

export default memo(YandexMessengerButton);
