import {FunctionComponent, useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';

import Flex from 'components/Flex/Flex';
import Text, {TTextSize} from 'components/Text/Text';
import LinkButton from 'components/LinkButton/LinkButton';
import MessageOutlineIcon24 from 'icons/24/MessageOutline';
import {TLinkThemeType} from 'components/Link/Link';
import YandexMessenger, {
    IYandexMessengerCommonProps,
    IYandexMessengerRenderTriggerProps,
} from 'components/YandexMessenger/YandexMessenger';

if (__CLIENT__) {
    require('@yandex-int/messenger.widget/lib/ui/popup.css');
}

import cx from './YandexMessengerLink.scss';

interface IYandexMessengerProps
    extends IYandexMessengerCommonProps,
        IWithClassName {
    triggerClassName?: string;
    label?: string;
    labelSize?: TTextSize;
    title?: string;
    withIcon?: boolean;
    theme?: TLinkThemeType;
}

const YandexMessengerLink: FunctionComponent<IYandexMessengerProps> = ({
    className,
    triggerClassName,
    title,
    label,
    labelSize,
    withIcon = true,
    theme = 'black',
    ...messengerProps
}) => {
    const renderTrigger = useCallback(
        ({ref, handleClick}: IYandexMessengerRenderTriggerProps) => {
            return (
                <Flex
                    ref={ref}
                    className={triggerClassName}
                    alignItems="center"
                    between={2}
                    inline
                    onClick={handleClick}
                >
                    {withIcon && <MessageOutlineIcon24 />}
                    {label && (
                        <Text
                            className={cx('text')}
                            color="current"
                            size={labelSize}
                        >
                            {label}
                        </Text>
                    )}
                </Flex>
            );
        },
        [label, labelSize, triggerClassName, withIcon],
    );

    return (
        <LinkButton className={className} theme={theme} title={title}>
            <YandexMessenger
                renderTrigger={renderTrigger}
                {...messengerProps}
            />
        </LinkButton>
    );
};

export default YandexMessengerLink;
