import {IAppVersion} from 'reducers/common/appVersion/types';

import {IDevice, TUserInfo} from 'reducers/common/commonReducerTypes';

export type TEntryPoint =
    | 'header'
    | 'sideSheet'
    | 'hotelsSearch'
    | 'hotelPage'
    | 'hotelBookPage'
    | 'tripPage'
    | 'tripsPage'
    | 'tripHotelOrder'
    | 'hotelOrder'
    | 'buses'
    | 'trains'
    | 'extranetHeader';

interface IPrepareMetadataParams {
    userInfo: TUserInfo;
    deviceType: IDevice;
    appVersion: IAppVersion;
    entrypoint: TEntryPoint;
    additionalData?: object;
}

interface IChatMetadata {
    uid: string;
    device: string;
    os: string;
    'os version': string;
    'app version': string;
    browser: string;
    'browser version': string;
    url?: string;
    entrypoint: TEntryPoint;
}

export function prepareMetadata({
    userInfo,
    deviceType,
    appVersion,
    entrypoint,
    additionalData,
}: IPrepareMetadataParams): IChatMetadata {
    const browserParams =
        typeof window === 'undefined'
            ? {}
            : {
                  url: location.href,
              };

    return {
        uid: 'isAuth' in userInfo && userInfo.isAuth ? userInfo.uid : '',
        device: `${deviceType.isMobile ? 'mobile' : 'desktop'} browser`,
        os: deviceType.os.name,
        'os version': deviceType.os.version,
        'app version': appVersion.value,
        browser: deviceType.browser.name,
        'browser version': deviceType.browser.version,
        entrypoint,
        ...browserParams,
        ...additionalData,
    };
}
