import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import YandexStaticMaps from './YandexStaticMaps';

export default {
    title: 'Example/YandexStaticMaps',
    component: YandexStaticMaps,
} as Meta;

const coordinates = {lon: 37.62007, lat: 55.75363};
const lonlat = [coordinates.lon, coordinates.lat];
const pt = [`${[...lonlat, 'comma'].map(String).join(',')}`];

export const Simple: TStorybookFunctionComponent = () => (
    <YandexStaticMaps
        className="staticMap"
        layer="map"
        coordinates={coordinates}
        size={[450, 450]}
        zoom={13}
        pt={pt}
        scale="2.0"
        width={300}
        height={300}
        shouldUseKey={false}
    />
);
Simple.parameters = {
    info: {
        title: 'Статичная карта размера 450х450 пикселей в виде изображения 300х300 с меткой в центре.',
    },
};
