import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';

import YandexTravelLogo from './YandexTravelLogo';

export default {
    title: 'Example/YandexTravelLogo',
    component: YandexTravelLogo,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={[
            {
                name: 'base',
                props: {},
                example: <YandexTravelLogo />,
            },
            {
                name: 'withoutLinks',
                props: {withoutLinks: true},
                example: <YandexTravelLogo withoutLinks />,
            },
            {
                name: 'withYandexLogo',
                props: {withYandexLogo: true},
                example: <YandexTravelLogo withYandexLogo />,
            },
            {
                name: 'isSmall',
                props: {isSmall: true},
                example: <YandexTravelLogo isSmall />,
            },
        ]}
    />
);
