/* Constants */
import {EProjectName} from 'constants/common';
import {URLs} from 'constants/urls';

const DEFAULT_TRAVEL_LOGO_URL = '/';

/* Utilities */
export const getTravelLogoUrlByProject = (project?: EProjectName): string => {
    switch (project) {
        case EProjectName.AVIA:
        case EProjectName.BUSES:
        case EProjectName.HOTELS:
        case EProjectName.HOTELS_EXTRANET:
        case EProjectName.TRAINS: {
            return URLs[project];
        }

        default: {
            return DEFAULT_TRAVEL_LOGO_URL;
        }
    }
};
