import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Zoomable from './Zoomable';

export default {
    title: 'Example/Zoomable',
    component: Zoomable,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <div style={{width: '500px', height: '500px', border: '1px solid red'}}>
        <Zoomable childrenSize={{width: 3000, height: 3000}}>
            <img
                src="https://avatars.mds.yandex.net/get-yablogs/28577/file_1547708002022/orig"
                style={{width: '3000px', height: '3000px'}}
            />
        </Zoomable>
    </div>
);

export const HorizontalCropped: TStorybookFunctionComponent = () => (
    <div style={{width: '300px', height: '500px', border: '1px solid red'}}>
        <Zoomable childrenSize={{width: 3000, height: 2000}}>
            <img
                src="https://avatars.mds.yandex.net/get-yablogs/28577/file_1547708002022/orig"
                style={{width: '3000px', height: '2000px'}}
            />
        </Zoomable>
    </div>
);

export const VerticalCropped: TStorybookFunctionComponent = () => (
    <div style={{width: '500px', height: '300px', border: '1px solid red'}}>
        <Zoomable childrenSize={{width: 2000, height: 3000}}>
            <img
                src="https://avatars.mds.yandex.net/get-yablogs/28577/file_1547708002022/orig"
                style={{width: '2000px', height: '3000px'}}
            />
        </Zoomable>
    </div>
);

export const Small: TStorybookFunctionComponent = () => (
    <div style={{width: '500px', height: '500px', border: '1px solid red'}}>
        <Zoomable childrenSize={{width: 200, height: 300}}>
            <img
                src="https://avatars.mds.yandex.net/get-yablogs/28577/file_1547708002022/orig"
                style={{width: '200px', height: '300px'}}
            />
        </Zoomable>
    </div>
);
