import {FunctionComponent} from 'react';

import {IZoomableProps} from './types';

import {useMobile} from 'utilities/hooks/useMobile';

import ZoomableDesktop from './components/ZoomableDesktop/ZoomableDesktop';
import ZoomableMobile from './components/ZoomableMobile/ZoomableMobile';

const Zoomable: FunctionComponent<IZoomableProps> = props => {
    const isMobile = useMobile();

    if (isMobile) {
        return <ZoomableMobile {...props} />;
    }

    return <ZoomableDesktop {...props} />;
};

export default Zoomable;
