import {Point, Size} from 'components/Zoomable/types';

interface IBounds {
    minX: number;
    minY: number;
    maxX: number;
    maxY: number;
}

interface IBoundsParams {
    childrenSize: Size;
    newScale: number;
    byViewPort: boolean;
    viewportWidth: number;
    translation: Point;
    viewportHeight: number;
}

export function getXBoundsByViewport(
    scale: number,
    viewportWidth: number,
    childrenSize: Size,
): Pick<IBounds, 'minX' | 'maxX'> {
    const childrenWidth = childrenSize.width * scale;

    return {
        minX: Math.min(viewportWidth - childrenWidth, 0),
        maxX: Math.max(viewportWidth - childrenWidth, 0),
    };
}

export function getXYBounds({
    childrenSize,
    newScale,
    byViewPort,
    translation,
    viewportHeight,
    viewportWidth,
}: IBoundsParams): IBounds {
    const childrenWidth = childrenSize.width * newScale;
    const childrenHeight = childrenSize.height * newScale;

    const minX = byViewPort
        ? Math.min(viewportWidth - childrenWidth, translation.x, 0)
        : -childrenWidth;
    const maxX = byViewPort
        ? Math.max(viewportWidth - childrenWidth, translation.x, 0)
        : viewportWidth;

    const minY = byViewPort
        ? Math.min(viewportHeight - childrenHeight, translation.y, 0)
        : -childrenHeight;
    const maxY = byViewPort
        ? Math.max(viewportHeight - childrenHeight, translation.y, 0)
        : viewportHeight;

    return {minX, maxX, minY, maxY};
}
