import {Point} from '../../../types';

export function coordinateChange(
    coordinate: number,
    scaleRatio: number,
): number {
    return scaleRatio * coordinate - coordinate;
}

export function restrict(min: number, value: number, max: number): number {
    return Math.max(min, Math.min(value, max));
}

export function distance(point1: Point, point2: Point): number {
    const x = point1.x - point2.x;
    const y = point1.y - point2.y;

    return Math.sqrt(x * x + y * y);
}
