import {clickToPoint, pageToPoint} from '../../utilities';

import AbstractZoomable, {
    EDragDirectionMultiplier,
} from '../../components/AbstractZoomable/AbstractZoomable';

export default class ZoomableDesktop extends AbstractZoomable {
    protected zoomRatio = 2.5;
    protected dragDirectionMultiplier = EDragDirectionMultiplier.DIRECT;

    protected addListeners() {
        if (this.zoomableNode) {
            this.zoomableNode.addEventListener('click', this.handleClick);
            this.zoomableNode.addEventListener(
                'mousemove',
                this.handleMouseMove,
            );
        }
    }

    protected removeListeners() {
        if (this.zoomableNode) {
            this.zoomableNode.removeEventListener('click', this.handleClick);
            this.zoomableNode.removeEventListener(
                'mousemove',
                this.handleMouseMove,
            );
        }
    }

    private handleClick = (e: MouseEvent) => {
        const point = clickToPoint(e);
        e.preventDefault();

        if (this.state.scale === this.maxScale) {
            this.endDrag();
            this.changeScale(this.state.minScale - this.state.scale, point);
        } else {
            // порядок вызова важен, beingDrag зависит от
            this.changeScale(this.maxScale - this.state.scale, point);
            this.beingDrag(point);
        }

        this.tryCallOnClick(pageToPoint(e), clickToPoint(e));
    };

    private handleMouseMove = (e: MouseEvent) => {
        const point = clickToPoint(e);
        e.preventDefault();
        this.dragTo(point);
    };
}
