import {ReactNode, MutableRefObject} from 'react';

import {ClickEventHandler} from 'types/events';

export interface Point {
    x: number;
    y: number;
}

export interface Size {
    width: number;
    height: number;
}

export interface PagePoint {
    pageX: number;
    pageY: number;
}

export interface IZoomChangeData {
    scale: number;
    minScale: number;
    maxScale: number;
}

export interface ITranslationChangeData {
    leftBoundaryReached: boolean;
    rightBoundaryReached: boolean;

    translation: Point;
}

export interface IZoomableProps {
    children: ReactNode;
    controls?: ReactNode;
    childrenSize?: Size;
    onClick?: ClickEventHandler;
    onZoomChange?: (data: IZoomChangeData) => void;
    onTranslationChange?: (data: ITranslationChangeData) => void;
    /** MutableRefObject тут для того чтобы включать/выключать драг без перерендера */
    withDrag?: MutableRefObject<boolean>;
    disableZoom?: boolean;
}
