import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import ZoomableImage from './ZoomableImage';

export default {
    title: 'Example/ZoomableImage',
    component: ZoomableImage,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <div style={{width: '500px', height: '500px', border: '1px solid red'}}>
        <ZoomableImage src="https://avatars.mds.yandex.net/get-yablogs/28577/file_1547708002022/orig" />
    </div>
);

export const Vertical: TStorybookFunctionComponent = () => (
    <div style={{width: '300px', height: '500px', border: '1px solid red'}}>
        <ZoomableImage src="https://avatars.mds.yandex.net/get-yablogs/28577/file_1547708002022/orig" />
    </div>
);

export const Horizontal: TStorybookFunctionComponent = () => (
    <div style={{width: '500px', height: '300px', border: '1px solid red'}}>
        <ZoomableImage src="https://avatars.mds.yandex.net/get-yablogs/28577/file_1547708002022/orig" />
    </div>
);

export const Small: TStorybookFunctionComponent = () => (
    <div style={{width: '500px', height: '500px', border: '1px solid red'}}>
        <ZoomableImage src="https://i.vimeocdn.com/portrait/2546876_300x300" />
    </div>
);
