import {
    FunctionComponent,
    MutableRefObject,
    useState,
    useCallback,
} from 'react';

import {
    ITranslationChangeData,
    IZoomChangeData,
    Size,
} from 'components/Zoomable/types';

import Zoomable from 'components/Zoomable/Zoomable';
import Image, {IImageProps} from 'components/TravelImage/TravelImage';

interface IZoomableImageProps extends IImageProps {
    disableZoom?: boolean;
    withDrag?: MutableRefObject<boolean>;
    onZoomChange?: (data: IZoomChangeData) => void;
    onTranslationChange?: (data: ITranslationChangeData) => void;
}

const ZoomableImage: FunctionComponent<IZoomableImageProps> = ({
    onLoad,
    onClick,
    onZoomChange,
    onTranslationChange,
    disableZoom,
    withDrag,
    children,
    ...rest
}) => {
    const [size, setSize] = useState<Size>();

    const handleLoad = useCallback(
        (image: HTMLImageElement) => {
            setSize({width: image.naturalWidth, height: image.naturalHeight});

            if (typeof onLoad === 'function') {
                onLoad(image);
            }
        },
        [onLoad, setSize],
    );

    return (
        <Zoomable
            controls={children}
            childrenSize={size}
            disableZoom={disableZoom}
            withDrag={withDrag}
            onClick={onClick}
            onTranslationChange={onTranslationChange}
            onZoomChange={onZoomChange}
        >
            <Image {...rest} onLoad={handleLoad} />
        </Zoomable>
    );
};

export default ZoomableImage;
