interface IFormFieldProps {
    type: string;
    // размер с учётом пустого места (например, для небольших полей на всю строку)
    // если эта величина не задана, то она отличается в зависимости от компонента и передается в buildFormFields
    size?: string;
    sizeParts: number;
    // размер без учёта пустого места
    sizeInput?: string;
    small?: boolean;
    documents: boolean;
}

interface IFormFieldsProps {
    [name: string]: IFormFieldProps;
}

export const FORM_FIELDS: IFormFieldsProps = {
    title: {
        type: 'text',
        size: 'big',
        sizeParts: 1,
        small: true,
        documents: false,
    },
    lastName: {
        type: 'text',
        size: 'big',
        sizeParts: 1,
        documents: true,
    },
    firstName: {
        type: 'text',
        size: 'middle',
        sizeParts: 0.5,
        documents: true,
    },
    middleName: {
        type: 'text',
        size: 'middle',
        sizeParts: 0.5,
        documents: true,
    },
    lastNameEn: {
        type: 'text',
        size: 'big',
        sizeParts: 1,
        documents: true,
    },
    firstNameEn: {
        type: 'text',
        size: 'middle',
        sizeParts: 0.5,
        documents: true,
    },
    middleNameEn: {
        type: 'text',
        size: 'middle',
        sizeParts: 0.5,
        documents: true,
    },
    birthDate: {
        type: 'date',
        size: 'small',
        sizeParts: 0.25,
        documents: false,
    },
    gender: {
        type: 'radio',
        size: 'small',
        sizeParts: 0.25,
        documents: false,
    },
    citizenship: {
        type: 'select',
        size: 'middle',
        sizeParts: 0.5,
        documents: true,
    },
    type: {
        type: 'select',
        size: 'middle',
        sizeParts: 0.5,
        documents: false,
    },
    number: {
        type: 'text',
        size: 'small',
        sizeParts: 0.25,
        documents: true,
    },
    expirationDate: {
        type: 'date',
        size: 'small',
        sizeParts: 0.25,
        documents: true,
    },
    cardName: {
        type: 'select',
        size: 'middle',
        sizeParts: 0.5,
        documents: false,
    },
    cardNumber: {
        type: 'text',
        size: 'middle',
        sizeParts: 0.5,
        documents: false,
    },
    itn: {
        type: 'text',
        sizeParts: 1,
        sizeInput: 'middle',
        documents: false,
    },
    email: {
        type: 'text',
        size: 'middle',
        sizeParts: 0.5,
        documents: false,
    },
    phone: {
        type: 'text',
        size: 'middle',
        sizeParts: 0.5,
        documents: false,
    },
    train_notifications_enabled: {
        type: 'checkbox',
        size: 'big',
        sizeParts: 1,
        documents: false,
    },
};

export const ACCOUNT_LAST_SUCCEED_ORDER_STORAGE =
    'yandexTravel/accountLastSucceedOrder';
