import {EAffiliateField} from 'types/affiliate/EAffiliateField';

export enum EAffiliateQueryParams {
    AFFILIATE_CLID = 'affiliate_clid',
    ADMITAD_UID = 'admitad_uid',
    TRAVEL_PAYOUTS_UID = 'travelpayouts_uid',
    AFFILIATE_VID = 'affiliate_vid',

    /*
     * White Label
     */
    REFERRAL_PARTNER_REQUEST_ID = 'referral_partner_request_id',
}

export const PARTNERS_QUERY_PARAMS = Object.values(EAffiliateQueryParams);

export const affiliateQueryParamsMap: Record<
    EAffiliateField,
    EAffiliateQueryParams
> = {
    [EAffiliateField.AFFILIATE_CLID]: EAffiliateQueryParams.AFFILIATE_CLID,
    [EAffiliateField.AFFILIATE_VID]: EAffiliateQueryParams.AFFILIATE_VID,
    [EAffiliateField.ADMITAD_UID]: EAffiliateQueryParams.ADMITAD_UID,
    [EAffiliateField.TRAVEL_PAYOUTS_UID]:
        EAffiliateQueryParams.TRAVEL_PAYOUTS_UID,
    [EAffiliateField.REFERRAL_PARTNER_REQUEST_ID]:
        EAffiliateQueryParams.REFERRAL_PARTNER_REQUEST_ID,
};
