import {TDocumentType} from 'types/common/document/TDocumentType';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

export {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

export const RUSSIAN_PASSPORT = 'ru_national_passport';
export const RUSSIAN_INTERNATIONAL_PASSPORT = 'ru_foreign_passport';
export const BIRTH_CERTIFICATE = 'ru_birth_certificate';
export const SAILOR_PASSPORT = 'ru_seaman_passport';
export const MILITARY_CARD = 'ru_military_id';
export const DOCUMENT_OTHER = 'other';
export const FOREIGN_DOCUMENT = 'other';

export const documentTypes: TDocumentType[] = [
    RUSSIAN_PASSPORT,
    RUSSIAN_INTERNATIONAL_PASSPORT,
    BIRTH_CERTIFICATE,
    SAILOR_PASSPORT,
    MILITARY_CARD,
    DOCUMENT_OTHER,
];

export const documentFormats: Partial<
    Record<
        EDocumentType,
        {
            mask: RegExp;
            placeholder: string;
        }
    >
> = {
    [EDocumentType.RU_NATIONAL_PASSPORT]: {
        mask: /(\d{4})(\d{6})/,
        placeholder: '$1 $2',
    },
    [EDocumentType.RU_BIRTH_CERTIFICATE]: {
        mask: /([IMXV]+)([А-ЯЁа-яё]{2})(\d{6})/,
        placeholder: '$1-$2 №$3',
    },
    [EDocumentType.RU_SEAMAN_PASSPORT]: {
        mask: /([\dA-Za-zА-Яа-яЁё]{2})(\d{7})/,
        placeholder: '$1 $2',
    },
    [EDocumentType.RU_FOREIGN_PASSPORT]: {
        mask: /(\d{2})(\d{7})/,
        placeholder: '$1 $2',
    },
};
