import {TROUBLESHOOTING_FORM_URL} from 'constants/common';

import {IAccountOrdersError} from 'reducers/account/orders/types/IAccountOrdersError';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/account-Order';

import Link from 'components/Link/Link';
import SupportPhone from 'components/SupportPhone/SupportPhone';

export const OPERATION_ORDER_ERROR: IAccountOrdersError = {
    text: i18nBlock.errorModalDotOperationFailed(),
};

export const FETCH_ORDER_ERROR: IAccountOrdersError = {
    text: insertJSXIntoKey(i18nBlock.errorModalDotInfo)({
        phone: <SupportPhone />,
        link: (
            <Link
                url={TROUBLESHOOTING_FORM_URL}
                target="_blank"
                rel="noopener noreferrer"
            >
                {i18nBlock.errorModalDotFeedbackLink()}
            </Link>
        ),
    }),
};
