import {ANDROID, IOS, WEB, WP} from 'server/constants/platforms';

export type TPlatform = typeof WEB | typeof IOS | typeof ANDROID | typeof WP;

export enum EAppActions {
    ADD_TO_FAVORITES = 'addToFavorites',
    REMOVE_FROM_FAVORITES = 'removeFromFavorites',
    SHARE = 'share', // не используется, контрол отсутствует
    SHOW_SEARCH_FORM = 'showSearchForm',
    BUY_TICKETS = 'buyTickets',
    OPEN_HISTORY = 'openHistory',
    OPEN_MENU = 'openMenu',
    REPORT_METRICS_EVENT = 'reportMetricsEvent',

    /**
     * Переход на главную портала
     */
    NAVIGATE_TO_INDEX_PAGE = 'navigateToIndexPage',

    /**
     * Переход на поиск отелей
     */
    NAVIGATE_TO_SEARCH_HOTELS_PAGE = 'navigateToSearchHotelsPage',

    /**
     * Переход на страницу поездок
     */
    NAVIGATE_TO_TRIPS_PAGE = 'navigateToTripsPage',

    /**
     * Переход на поиск авиа
     */
    NAVIGATE_TO_SEARCH_AVIA_PAGE = 'navigateToSearchAviaPage',

    /**
     * Переход на страницу с вариантом
     * AviaOrder
     */
    NAVIGATE_TO_VARIANT_AVIA_PAGE = 'navigateToVariantAviaPage',

    /**
     * Переход на страницу с вариантом
     */
    NAVIGATE_TO_VARIANT_HOTELS_PAGE = 'navigateToVariantHotelsPage',

    /**
     * Переход на страницу выдачи отелей
     */
    NAVIGATE_TO_SEARCH_RESULT_HOTELS_PAGE = 'navigateToSearchResultHotelsPage',

    /**
     * Переход по внешней ссылке
     */
    NAVIGATE_TO_EXTERNAL_URL = 'navigateToExternalUrl',

    /**
     * Создание отельного заказа
     */
    CREATE_HOTEL_ORDER = 'createHotelOrder',

    /**
     * Создание заказа авиа
     */
    CREATE_AVIA_ORDER = 'createAviaOrder',

    /**
     * Монтирование на страницу заглушки траста для TravelApp
     */
    MOUNT_TRUST_STUB = 'mountTrustStub',

    /**
     * Установка кук для тестового контекста авиа
     */
    SET_AVIA_TEST_CONTEXT = 'setAviaTestContext',

    /**
     * Установка кук для платежного контекста
     */
    SET_PAYMENT_TEST_CONTEXT = 'setPaymentTestContext',

    /**
     * Переход на страницу избранного
     */
    NAVIGATE_TO_FAVORITES = 'navigateToFavorites',

    /**
     * Открывает нативную авторизацию
     */
    OPEN_AUTHORIZATION = 'openAuthorization',
}
