import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';

import {ORDER_STATUS_VALUES} from 'projects/account/lib/orders/statuses';

const type = `:type(${ORDER_TYPE_VALUES.TRAINS}|${ORDER_TYPE_VALUES.HOTELS}|${ORDER_TYPE_VALUES.AVIA})?`;
const status = `:status(${ORDER_STATUS_VALUES.DONE}|${ORDER_STATUS_VALUES.PROGRESS})?`;
const page = `:page([0-9]+)?`;
const search = ':search(search)?';

export const accountRoot = '/my';
export const accountOrder = `${accountRoot}/order/:orderId`;
export const accountSearchOrders = `${accountRoot}/${type}/${status}/${page}/${search}`;
export const accountPassenger = `${accountRoot}/passengers/:userId?`;
export const accountPassengers = `${accountRoot}/passengers`;
export const accountTrips = `${accountRoot}/trips`;
export const accountTripsSearch = `${accountRoot}/trips/search`;
export const accountToursSearch = `${accountRoot}/trips/tours-search-form`;
export const accountTrip = `${accountRoot}/trips/:tripId`;
