export const aviaRoot = '/avia';
export const aviaOrder = `${aviaRoot}/order` as const;
export const aviaOrderById = `${aviaRoot}/orders/:id` as const;
export const aviaSubscription = `${aviaRoot}/subscription` as const;
export const aviaConfirmSubscription = `${aviaSubscription}/confirm` as const;
export const aviaUnsubscribe = `${aviaSubscription}/unsubscribe` as const;
export const aviaUnsubscribeByDirection =
    `${aviaUnsubscribe}/by_direction` as const;
export const aviaBooking = `${aviaRoot}/booking` as const;
export const aviaBookingResult = `${aviaBooking}/result/:orderId` as const;
export const aviaBookingPayment =
    `${aviaBooking}/:token/payment/:orderId` as const;
export const aviaBookingFinishPayment =
    `${aviaBooking}/payments/finish` as const;
export const aviaBookingPaymentRedirectTarget =
    `${aviaBooking}/payments/process` as const;
export const aviaSearchRoot = `${aviaRoot}/search` as const;
export const aviaSearchResults = `${aviaSearchRoot}/result` as const;
export const aviaSearchError = `${aviaSearchRoot}/error` as const;
export const aviaNearAirports = `${aviaSearchResults}/near` as const;
export const aviaRedirect = `${aviaRoot}/redirect` as const;
export const aviaRedirectError = `${aviaRoot}/redirect/error` as const;
export const aviaRoute = `${aviaRoot}/routes/:fromSlug--:toSlug` as const;
export const aviaFlightsTo = `${aviaRoot}/flights-to/:toSlug` as const;
export const aviaFlight = `${aviaRoot}/flights/:iataAndFlightNumber` as const;
export const aviaSearchToCountryRoot = `${aviaRoot}/toCountry` as const;
export const aviaSearchToCountry =
    `${aviaSearchToCountryRoot}/:from--:to/` as const;
export const aviaSearchToAnywhereRoot = `${aviaRoot}/toAnywhere` as const;
export const aviaSearchToAnywhere =
    `${aviaSearchToAnywhereRoot}/:from/` as const;
