import {EProjectName} from 'constants/common';

import * as partnersUrls from './partners';
import * as accountUrls from './account';
import * as aviaUrls from './avia';
import * as hotelsUrls from './hotels';
import * as hotelsExtranetUrls from './hotelsExtranet';
import * as trainsUrls from './trains';
import * as busesUrls from './buses';
import * as testControlPanelUrls from './testControlPanel';
import * as subscriptionUrls from './subscription';
import * as favoritesUrls from './favorites';
import * as journalUrls from './journal';
import * as promoUrls from './promo';
import * as toursUrls from './tours';
import * as ampUrls from './amp';

const index = '/';
const notFound = '/404';

const legacyHotelRoot = '/hotel';
const legacyHotelPage = `${legacyHotelRoot}/:hotelId`;

const votkuda = '/votkuda';
const mirCashback = '/cashbackmir';

const {favorites, ...restFavoritesUrls} = favoritesUrls;

export const URLs = {
    [EProjectName.INDEX]: index,
    [EProjectName.WHITE_LABEL]: index,
    [EProjectName.AVIA]: aviaUrls.aviaRoot,
    [EProjectName.TRAINS]: trainsUrls.trainsRoot,
    [EProjectName.HOTELS]: hotelsUrls.hotelsRoot,
    [EProjectName.HOTELS_EXTRANET]: hotelsExtranetUrls.hotelsExtranetRoot,
    [EProjectName.HOTEL]: legacyHotelRoot,
    [EProjectName.BUSES]: busesUrls.busesRoot,
    [EProjectName.ACCOUNT]: accountUrls.accountRoot,
    [EProjectName.TEST_CONTROL_PANEL]:
        testControlPanelUrls.testControlPanelRoot,
    [EProjectName.PARTNERS]: partnersUrls.partnersRoot,
    [EProjectName.SUBSCRIPTION]: subscriptionUrls.subscriptionRoot,
    [EProjectName.NOT_FOUND]: notFound,
    [EProjectName.FAVORITES]: favorites,
    [EProjectName.JOURNAL]: journalUrls.journalRoot,
    [EProjectName.TOURS]: toursUrls.toursRoot,

    ...ampUrls,
    ...aviaUrls,
    ...busesUrls,
    ...promoUrls,
    ...toursUrls,
    ...hotelsUrls,
    ...trainsUrls,
    ...accountUrls,
    ...journalUrls,
    ...partnersUrls,
    ...subscriptionUrls,
    ...restFavoritesUrls,
    ...hotelsExtranetUrls,
    ...testControlPanelUrls,

    legacyHotelPage,

    votkuda,
    mirCashback,
};
