import {EDirection} from 'types/common/EDirection';
import {EFirmTrain} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';

import {convertDirectionToPathDirection} from 'projects/trains/lib/urls/pathDirectionHelpers';

/**
 * Сепаратор выделен отдельно, чтоб глупенький path-to-regexp не включал
 * его в исключающие символы для поиска toSlug
 */
const TRAINS_SEARCH = '/:fromSlug:sep(--):toSlug';

const TRAINS_OLD_SEARCH_WITH_WHEN_PARAM =
    '/:fromSlug:sep(--):toSlug/:when(20\\d{2}-\\d{2}-\\d{2}|tomorrow|after-tomorrow|today)';

const TRAINS_OLD_SEARCH = '/search/';

const TRAINS_ORDER = '/order/';

const TRAINS_PARTNER_REDIRECT = '/partner-redirect/';

const directionPathParams = Object.values(EDirection)
    .map(d => convertDirectionToPathDirection(d))
    .join('|');

const firmTrainsPathParams = Object.values(EFirmTrain).join('|');

export const trainsRoot = '/trains';
export const trainsOldSearch = `${trainsRoot}${TRAINS_OLD_SEARCH}`;
export const trainsOldSearchWithWhenParam = `${trainsRoot}${TRAINS_OLD_SEARCH_WITH_WHEN_PARAM}`;
export const trainsSearch = `${trainsRoot}${TRAINS_SEARCH}`;
export const trainsOrder = `${trainsRoot}${TRAINS_ORDER}`;
export const trainsOrderPlaces = `${trainsOrder}:direction(${directionPathParams})?/:index(\\d)?/`;
export const trainsOrderPassengers = `${trainsOrder}passengers/`;
export const trainsOrderConfirm = `${trainsOrder}confirm/`;
export const trainsOrderPayment = `${trainsOrder}payment/`;
export const trainsOrderFinishPayment = `${trainsOrder}finishPayment/`;
export const trainsOrderHappyPage = `${trainsOrder}success/`;
export const trainsPartnerRedirect = `${trainsRoot}${TRAINS_PARTNER_REDIRECT}`;
export const trainsPopularRoutes = `${trainsRoot}/popular-routes`;
export const trainsAuthorizeTicket = `${trainsRoot}/authorizeTicket`;
export const trainsFirmTrain = `${trainsRoot}/:slug(${firmTrainsPathParams})`;
