import React, {useEffect} from 'react';
import {useSelector} from 'react-redux';

import entryPageSelector from 'selectors/common/entryPageSelector';

import {logError} from 'utilities/logger/logError';
import {params as sendMetrikaParams} from 'utilities/metrika';
import {updateAffiliateCookie} from 'utilities/attribution/updateAffiliateCookie';
import {getMetrikaParams} from 'containers/AffiliateMarker/utilities/getMetrikaParams';

const AffiliateMarker: React.FC = () => {
    const entry = useSelector(entryPageSelector);

    useEffect(() => {
        if (entry && window.top === window) {
            try {
                updateAffiliateCookie(entry);

                const metrikaParams = getMetrikaParams();

                if (metrikaParams) {
                    sendMetrikaParams(metrikaParams);
                }
            } catch (error) {
                logError(
                    {
                        message: `[YATRAVEL] Ошибка при парсинге и записи параметров аффилиатки`,
                        block: 'AffiliateMarker',
                    },
                    error,
                );
            }
        }
    }, [entry]);

    return null;
};

export default AffiliateMarker;
