import Cookie from 'js-cookie';
import {isEmpty, pick} from 'lodash';

import {AFFILIATE_COOKIE_NAME} from 'constants/affiliate/cookieName';
import {UTM_ATTRIBUTION_FIELDS} from 'constants/attribution/utmAttributionFields';

import {AFFILIATE_FIELDS} from 'types/affiliate/EAffiliateField';
import {IAffiliateParams} from 'types/affiliate/IAffiliateParams';
import IAttributionUTMDataValues from 'types/attribution/IAttributionUTMDataValues';
import {IMetrikaCommonAttributionParams} from 'utilities/metrika/types/params/common';
import {ECookieName} from 'server/utilities/DataStorage/AttributionData/types/ICookie';

function getAffiliateParamsFromCookie(): IAffiliateParams | undefined {
    try {
        const data = Cookie.get(AFFILIATE_COOKIE_NAME);

        return data ? pick(JSON.parse(data), AFFILIATE_FIELDS) : undefined;
    } catch (err) {}
}

function getUtmParamsFromCookie(): IAttributionUTMDataValues | undefined {
    try {
        const data = Cookie.get(ECookieName.TRAVEL_ATTRIBUTION_SESSION);

        return data
            ? pick(JSON.parse(data), UTM_ATTRIBUTION_FIELDS)
            : undefined;
    } catch (err) {}
}

export function getMetrikaParams():
    | IMetrikaCommonAttributionParams
    | undefined {
    const common: IMetrikaCommonAttributionParams['common'] = {};
    const affiliate = getAffiliateParamsFromCookie();
    const utm = getUtmParamsFromCookie();

    if (affiliate && !isEmpty(affiliate)) {
        common.affiliate = affiliate;
    }

    if (utm && !isEmpty(utm)) {
        common.utm = utm;
    }

    return isEmpty(common) ? undefined : {common};
}
