import React, {useMemo} from 'react';
import {useSelector} from 'react-redux';

import {JAEGER_TRACER_OPTIONS} from 'server/constants/common';
import {BUG_SCRIPT} from 'constants/urls/externals';

import featuresSelector from 'selectors/common/featuresSelector';
import userSplitSelector from 'selectors/common/userSplitSelector';
import isBotSelector from 'selectors/common/isBot';

import appData from 'utilities/appData/appData';
import {useNeedToLoadDynamicResource} from 'utilities/hooks/useNeedToLoadDynamicResource';
import {isE2ETesting} from 'utilities/testUtils/isE2ETesting';

import DynamicScript from 'components/DynamicScript/DynamicScript';

import './BugScript.scss';

const {TRACER_DEBUG_TAG_NAME} = JAEGER_TRACER_OPTIONS;

const BugScript: React.FC = () => {
    const features = useSelector(featuresSelector);
    const userSplit = useSelector(userSplitSelector);
    const isBot = useSelector(isBotSelector);
    const isE2E = isE2ETesting();

    const needToLoadScript = useNeedToLoadDynamicResource({
        timeoutProportion: 10,
        maxProportionTimeout: 7000,
    });

    const jaegerDebugId = appData.getByKey('jaegerDebugId');
    const appEnv = appData.getByKey('appEnv');

    const {testIds = ''} = userSplit;
    const experiments = testIds.split(';').join(',');

    let jaegerLink: string | null = null;

    try {
        if (jaegerDebugId) {
            const jaegerEnv =
                appEnv === 'production' ? 'travel' : 'travel-test';

            jaegerLink = String(
                new URL(
                    `${jaegerEnv}/search?service=travel-front&tags={"${TRACER_DEBUG_TAG_NAME}":"${jaegerDebugId}"}`,
                    'https://jaeger.yt.yandex-team.ru/',
                ),
            );
        }
    } catch (e) {}

    const attrs = useMemo(() => {
        return {
            'data-info': jaegerLink
                ? JSON.stringify({
                      Jaeger: jaegerLink,
                  })
                : undefined,
            'data-text': jaegerLink ? jaegerLink : undefined,
            'data-data': JSON.stringify({
                features,
                experiments,
            }),
            'data-exp': `experiments: ${experiments}`,
            position: 'left',
            modules: 'forms,info,ab',
            form: '10019250.de0cbb73584276e1d9621e16513bf3adcfc3496a',
            'data-domain': 'yandex',
            id: 'yndxbug',
        };
    }, [experiments, features, jaegerLink]);

    if (!needToLoadScript || isBot || isE2E) {
        return null;
    }

    return <DynamicScript src={BUG_SCRIPT} attrs={attrs} />;
};

export default React.memo(BugScript);
