import React, {useEffect} from 'react';

import {EToggler} from 'types/common/togglers/EToggler';

import useCookieToggler from 'utilities/hooks/useCookieToggler';
import {useWasNavigation} from 'utilities/hooks/useWasNavigation';

const FontsSwapper: React.FC = () => {
    const {value: fontsLoaded, toggle: toggleHasFontsLoaded} = useCookieToggler(
        EToggler.FONTS_LOADED,
    );

    const wasNavigation = useWasNavigation();

    useEffect(() => {
        if (fontsLoaded || !wasNavigation) {
            return;
        }

        document.body.classList.add('fontsLoaded');

        toggleHasFontsLoaded();
    }, [fontsLoaded, toggleHasFontsLoaded, wasNavigation]);

    return null;
};

export default React.memo(FontsSwapper);
