import {FC, memo, useEffect} from 'react';
import {useSelector} from 'react-redux';

import isNetworkOnlineSelector from 'selectors/common/isNetworkOnlineSelector';

import {reloadPage} from 'utilities/browser/reloadPage';
import {logWarning} from 'utilities/logger/logWarning';

import * as i18n from 'i18n/networkOfflineError';

import ErrorModal, {TErrorActionType} from 'components/ErrorModal/ErrorModal';

interface INetworkErrorProps {}

const PRIMARY_ACTION: TErrorActionType = {
    title: i18n.primaryButton(),
    type: 'button',
    handler: reloadPage,
};

const NetworkError: FC<INetworkErrorProps> = () => {
    const isNetworkOnline = useSelector(isNetworkOnlineSelector);

    useEffect(() => {
        if (!isNetworkOnline) {
            logWarning({
                message: '[YATRAVEL] Пропал интернет',
            });
        }
    }, [isNetworkOnline]);

    if (isNetworkOnline) {
        return null;
    }

    return (
        <ErrorModal
            title={i18n.title()}
            text={i18n.text()}
            primaryAction={PRIMARY_ACTION}
            isVisible
        />
    );
};

export default memo(NetworkError);
