import {LoadableComponent} from '@loadable/component';

import {EProjectName} from 'constants/common';

import {loadable} from 'utilities/pageLoadable';

const AviaPage = loadable(() => import('projects/avia/AviaApp'));

const HotelsApp = loadable(
    () => import('projects/hotels/applications/HotelsApp/HotelsApp'),
);

const HotelsExtranetApp = loadable(
    () => import('projects/hotelsExtranet/applications/HotelsExtranetApp'),
);

const LegacyHotelApp = loadable(
    () => import('projects/hotels/applications/LegacyHotelApp/LegacyHotelApp'),
);

const TrainsApp = loadable(
    () => import('projects/trains/components/TrainsApp/TrainsApp'),
);

const BusesApp = loadable(
    () => import('projects/buses/applications/BusesApp/BusesApp'),
);

const UserAccountApp = loadable(
    () => import('projects/account/UserAccountApp/UserAccountApp'),
);

const TestControlPanelApp = loadable(
    () => import('projects/testControlPanel/TestControlPanelApp'),
);

const SubscriptionApp = loadable(
    () => import('projects/subscription/SubscriptionApp'),
);

const PartnersApp = loadable(() => import('projects/partners/PartnersApp'));

const IndexApp = loadable(() => import('projects/index/IndexApp/IndexApp'));

const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

const FavoritesApp = loadable(() => import('projects/favorites/FavoritesApp'));

const JournalApp = loadable(() => import('projects/journal/JournalApp'));

const WhiteLabelApp = loadable(
    () => import('projects/whiteLabel/WhiteLabelApp'),
);

export default (projectType: EProjectName): LoadableComponent<any> => {
    switch (projectType) {
        case EProjectName.AVIA:
            return AviaPage;
        case EProjectName.HOTELS:
            return HotelsApp;
        case EProjectName.HOTELS_EXTRANET:
            return HotelsExtranetApp;
        case EProjectName.ACCOUNT:
            return UserAccountApp;
        case EProjectName.HOTEL:
            return LegacyHotelApp;
        case EProjectName.BUSES:
            return BusesApp;
        case EProjectName.TRAINS:
            return TrainsApp;
        case EProjectName.NOT_FOUND:
            return NotFoundApp;
        case EProjectName.TEST_CONTROL_PANEL:
            return TestControlPanelApp;
        case EProjectName.SUBSCRIPTION:
            return SubscriptionApp;
        case EProjectName.PARTNERS:
            return PartnersApp;
        case EProjectName.FAVORITES:
            return FavoritesApp;
        case EProjectName.JOURNAL:
            return JournalApp;
        case EProjectName.WHITE_LABEL:
            return WhiteLabelApp;
        default:
            return IndexApp;
    }
};
