import {FC, useEffect} from 'react';
import {useLocation} from 'react-router-dom';

import {getYtpRefererFromQuery, storeYtpReferer} from 'utilities/ytpReferer';

const YtpRefererSaver: FC = () => {
    const location = useLocation();
    const ytpReferer = getYtpRefererFromQuery(location.search);

    useEffect(() => {
        storeYtpReferer(ytpReferer as string);
    }, [ytpReferer]);

    return null;
};

export default YtpRefererSaver;
