import {FunctionComponent} from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import AmpHeader from 'projects/amp/components/AmpHeader/AmpHeader';
import AmpFooter from 'projects/amp/components/AmpFooter/AmpFooter';
import NotFoundWrapper from 'components/NotFound/NotFoundWrapper/NotFoundWrapper';

import AmpHotelPage from 'projects/amp/pages/AmpHotelPage/AmpHotelPage';

import cx from './AppAmp.scss';

const AppAmp: FunctionComponent = () => {
    return (
        <div className={cx('root')}>
            <AmpHeader />

            <Switch>
                <Route exact path={URLs.ampHotelsHotelWithSlug}>
                    <AmpHotelPage />
                </Route>
                <Route>
                    <NotFoundWrapper>404</NotFoundWrapper>
                </Route>
            </Switch>

            <AmpFooter />
        </div>
    );
};

export default AppAmp;
