import {FunctionComponent, useEffect} from 'react';

import {ECommonGoal} from 'utilities/metrika/types/goals/common';
import {ESubscriptionCode} from 'types/subscription/ESubscriptionCode';
import {IInlineSubscriptionContainerProps} from 'containers/Subscriptions/types';

import {reachGoal} from 'utilities/metrika';
import {useUserInfo} from 'utilities/hooks/useUserInfo';
import {isAuthUser} from 'utilities/userInfo/isAuthUser';
import {useSubscriptionHandlers} from 'containers/Subscriptions/utilities/useSubscriptionHandlers';
import {useAsyncSubscriptionConfig} from 'utilities/hooks/subscription/useFetchSubscriptionConfig';
import {useSubscriptionMetrikaParams} from 'containers/Subscriptions/utilities/useSubscriptionMetrikaParams';

import SubscriptionInline from 'components/SubscriptionInline/SubscriptionInline';
import SubscriptionSkeleton from 'components/SubscriptionSkeleton/SubscriptionSkeleton';
import SubscriptionInlineNew from 'components/SubscriptionInlineNew/SubscriptionInlineNew';

interface IInlineSubscriptionProps
    extends Omit<IInlineSubscriptionContainerProps, 'onSubmit' | 'email'> {
    rebranding?: boolean;
}

const InlineSubscription: FunctionComponent<IInlineSubscriptionProps> =
    props => {
        const {
            vertical,
            source,
            promoSubscriptionCode = ESubscriptionCode.travelNews,
            rebranding = false,
        } = props;
        const userInfo = useUserInfo();
        const {handleSubmit, handleTrySubmit} = useSubscriptionHandlers(
            vertical,
            source,
            promoSubscriptionCode,
        );
        const metrikaParams = useSubscriptionMetrikaParams(vertical, source);
        const state = useAsyncSubscriptionConfig(vertical);

        useEffect(() => {
            reachGoal(ECommonGoal.SUBSCRIPTION_BLOCK_SHOWN, metrikaParams);
        }, [metrikaParams]);

        if (rebranding) {
            return (
                <SubscriptionInlineNew
                    {...props}
                    loading={state.loading}
                    email={
                        isAuthUser(userInfo)
                            ? userInfo.contacts.email
                            : undefined
                    }
                    promoCode={state.data ?? undefined}
                    onSubmit={handleSubmit}
                    onBeforeSubmit={handleTrySubmit}
                />
            );
        }

        return state.loading ? (
            <SubscriptionSkeleton
                {...props}
                withPromoCode={Boolean(state.data)}
            />
        ) : (
            <SubscriptionInline
                {...props}
                email={
                    isAuthUser(userInfo) ? userInfo.contacts.email : undefined
                }
                promoCode={state.data ?? undefined}
                onSubmit={handleSubmit}
                onBeforeSubmit={handleTrySubmit}
            />
        );
    };

export default InlineSubscription;
