import {FunctionComponent} from 'react';

import {IInlineSubscriptionContainerProps} from 'containers/Subscriptions/types';

import {useIsUserSubscribed} from 'utilities/hooks/subscription/useIsUserSubscribed';

import InlineSubscription from 'containers/Subscriptions/Inline/InlineSubscription';

const OptionalSubscription: FunctionComponent<
    Omit<IInlineSubscriptionContainerProps, 'onSubmit'>
> = props => {
    const isUserSubscribed = useIsUserSubscribed();

    if (isUserSubscribed) {
        return null;
    }

    return <InlineSubscription {...props} />;
};

export default OptionalSubscription;
