import {FunctionComponent} from 'react';

import {ESubscriptionCode} from 'types/subscription/ESubscriptionCode';
import {IPopupSubscriptionContainerProps} from 'containers/Subscriptions/types';

import {useUserInfo} from 'utilities/hooks/useUserInfo';
import {isAuthUser} from 'utilities/userInfo/isAuthUser';
import {useIsUserSubscribed} from 'utilities/hooks/subscription/useIsUserSubscribed';
import {useSubscriptionHandlers} from 'containers/Subscriptions/utilities/useSubscriptionHandlers';
import {useAsyncSubscriptionConfig} from 'utilities/hooks/subscription/useFetchSubscriptionConfig';

import PopupSubscriptionController from 'containers/Subscriptions/Popup/PopupSubscriptionController';

const PopupSubscription: FunctionComponent<
    Omit<IPopupSubscriptionContainerProps, 'onSubmit'>
> = props => {
    const {
        vertical,
        source,
        promoSubscriptionCode = ESubscriptionCode.travelNews,
    } = props;
    const userInfo = useUserInfo();
    const {handleSubmit, handleTrySubmit} = useSubscriptionHandlers(
        vertical,
        source,
        promoSubscriptionCode,
    );

    const isUserSubscribed = useIsUserSubscribed();
    const state = useAsyncSubscriptionConfig(props.vertical);

    if (state.loading || isUserSubscribed) {
        return null;
    }

    return (
        <PopupSubscriptionController
            {...props}
            email={isAuthUser(userInfo) ? userInfo.contacts.email : undefined}
            promoCode={state.data ?? undefined}
            onSubmit={handleSubmit}
            onBeforeSubmit={handleTrySubmit}
        />
    );
};

export default PopupSubscription;
