import {FunctionComponent, useCallback, useEffect} from 'react';

import {SECOND} from 'utilities/dateUtils/constants';

import {ECommonGoal} from 'utilities/metrika/types/goals/common';
import {IPromoCodeForSubscription} from 'server/api/NotifierApi/types';
import {IPopupSubscriptionContainerProps} from 'containers/Subscriptions/types';

import {reachGoal} from 'utilities/metrika';
import {useBoolean} from 'utilities/hooks/useBoolean';
import {useLeaving} from 'utilities/hooks/userBehavior/useLeaving';
import {useInactivity} from 'utilities/hooks/userBehavior/useInactivity';
import wasClosedSaver from 'containers/Subscriptions/utilities/wasClosedSaver';
import {useSubscriptionMetrikaParams} from 'containers/Subscriptions/utilities/useSubscriptionMetrikaParams';

import SubscriptionPopup from 'components/SubscriptionPopup/SubscriptionPopup';

interface IPopupSubscriptionControllerProps
    extends IPopupSubscriptionContainerProps {
    promoCode?: IPromoCodeForSubscription;
}

const PopupSubscriptionController: FunctionComponent<IPopupSubscriptionControllerProps> =
    props => {
        const {vertical, source} = props;
        const {
            value: isVisible,
            setFalse: closePopup,
            setTrue: openPopup,
        } = useBoolean(false);

        const isLeaving = useLeaving(10 * SECOND);
        const isInactive = useInactivity(15 * SECOND);
        const metrikaParams = useSubscriptionMetrikaParams(vertical, source);

        useEffect(() => {
            if (!wasClosedSaver.wasClosed && (isLeaving || isInactive)) {
                openPopup();
                reachGoal(ECommonGoal.SUBSCRIPTION_BLOCK_SHOWN, metrikaParams);
            }
        }, [isLeaving, isInactive, openPopup, metrikaParams]);

        const handleClose = useCallback(() => {
            wasClosedSaver.saveWasClosed();
            closePopup();
        }, [closePopup]);

        return (
            <SubscriptionPopup
                {...props}
                isVisible={isVisible}
                onClose={handleClose}
            />
        );
    };

export default PopupSubscriptionController;
