import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';
import {ESubscriptionCode} from 'types/subscription/ESubscriptionCode';
import {ESubscriptionSource} from 'types/subscription/ESubscriptionSource';

import {ISubscriptionInlineProps} from 'components/SubscriptionInline/SubscriptionInline';
import {ISubscriptionContentProps} from 'components/SubscriptionContent/SubscriptionContent';

interface ISubscriptionParams {
    vertical: ESubscriptionVerticalName;
    source: ESubscriptionSource;
    promoSubscriptionCode?: ESubscriptionCode;
}

export interface IInlineSubscriptionContainerProps
    extends ISubscriptionParams,
        Omit<ISubscriptionInlineProps, 'promoCode'> {}

export interface IPopupSubscriptionContainerProps
    extends ISubscriptionParams,
        Omit<
            ISubscriptionContentProps,
            'promoCode' | 'pictureSize' | 'pictureClassName'
        > {}
