import {useCallback} from 'react';

import {AppError} from 'types/common/AppError';
import {ECommonGoal} from 'utilities/metrika/types/goals/common';
import {ESubscriptionCode} from 'types/subscription/ESubscriptionCode';
import {ESubscriptionSource} from 'types/subscription/ESubscriptionSource';
import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';

import {subscribeOnPromo} from 'reducers/common/subscription/promoCodeInfo/thunk';

import {reachGoal} from 'utilities/metrika';
import {useSubscriptionMetrikaParams} from 'containers/Subscriptions/utilities/useSubscriptionMetrikaParams';

import {alreadySubscribed} from 'i18n/subscription';

import {notifierService} from 'serviceProvider';

export function useSubscriptionHandlers(
    vertical: ESubscriptionVerticalName,
    source: ESubscriptionSource,
    promoSubscriptionCode: ESubscriptionCode,
): {
    handleSubmit(email: string): Promise<void>;
    handleTrySubmit(): void;
} {
    const metrikaParams = useSubscriptionMetrikaParams(vertical, source);

    const handleSubmit = useCallback(
        async (email: string) => {
            const isUserSubscribed = await notifierService
                .provider()
                .getStatus(email);

            if (isUserSubscribed) {
                throw new AppError(alreadySubscribed());
            }

            await subscribeOnPromo({
                email,
                promoSubscriptionCode,
                source,
                travelVerticalName: vertical,
            });
            reachGoal(ECommonGoal.SUBSCRIPTION_CONFIRMED, metrikaParams);
        },
        [source, vertical, promoSubscriptionCode, metrikaParams],
    );
    const handleTrySubmit = useCallback(() => {
        reachGoal(ECommonGoal.SUBSCRIPTION_FORM_SUBMIT, metrikaParams);
    }, [metrikaParams]);

    return {handleSubmit, handleTrySubmit};
}
