import React from 'react';
import {ReactReduxContext} from 'react-redux';
import {Reducer} from 'typesafe-actions';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import preloadReducers from 'reducers/utils/loadableReducers/preloadReducers';

export default function withReducers<P extends any>(
    reducersToPreload: [ELoadableReducer, Reducer<any, any>][],
): (Component: React.ComponentType<P>) => React.FC<P> {
    const hasAnyNewReducerPreloaded = preloadReducers(reducersToPreload);

    let haveAlreadyRefreshed = false;

    return function (Component): React.FC<P> {
        const wrapper: React.FC<P> = props => (
            <ReactReduxContext.Consumer>
                {({store}): React.ReactNode => {
                    if (!haveAlreadyRefreshed && hasAnyNewReducerPreloaded) {
                        haveAlreadyRefreshed = true;

                        store.refreshReducers();
                    }

                    return <Component {...props} />;
                }}
            </ReactReduxContext.Consumer>
        );

        wrapper.displayName = `withReducers(${
            Component.displayName || Component.name
        })`;

        return wrapper;
    };
}
