/* global __CLIENT__ */

import React from 'react';
import {Saga} from 'redux-saga';
import {ReactReduxContext} from 'react-redux';

const sagaInjected = Symbol('sagaInjected');

export default function withSaga<P extends any>(
    saga: Saga | Saga[],
): (
    Component: React.ComponentType<P> & {[sagaInjected]?: true},
) => React.FC<P> {
    return function (Component): React.FC<P> {
        const sagged: React.FC<P> = props => (
            <ReactReduxContext.Consumer>
                {({store}): React.ReactNode => {
                    if (__CLIENT__ && !Component[sagaInjected]) {
                        if (Array.isArray(saga)) {
                            saga.forEach(store.injectSaga);
                        } else {
                            store.injectSaga(saga);
                        }

                        Component[sagaInjected] = true;
                    }

                    return <Component {...props} />;
                }}
            </ReactReduxContext.Consumer>
        );

        sagged.displayName = `withSaga(${
            Component.displayName || Component.name
        })`;

        return sagged;
    };
}
