import {FC, createContext} from 'react';
import {useSelector} from 'react-redux';

import {DEFAULT_CURRENCIES} from 'reducers/common/currencies/reducer';

import {priceComparatorSelector} from 'selectors/common/currenciesSelector';

import {PriceConverter} from 'utilities/currency/priceConverter';
import {PriceComparator} from 'utilities/currency/compare';

export const PriceComparatorContext = createContext(
    new PriceComparator(
        new PriceConverter({
            currenciesInfo: DEFAULT_CURRENCIES,
        }),
    ),
);

export const PriceComparatorProvider: FC = props => {
    const priceComparator = useSelector(priceComparatorSelector);

    return (
        <PriceComparatorContext.Provider value={priceComparator}>
            {props.children}
        </PriceComparatorContext.Provider>
    );
};
